﻿//////////////////////////////////////////////
// CheckBox.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkWinUi
#include "Component.h"

#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <functional>

/// Class ------------------------------------
	
namespace nkWinUi
{
	class DLL_WINUI_EXPORT CheckBox : public Component
	{		
		public :
		
			// Constructeur, destructeur
			CheckBox (System* system) noexcept ;
			virtual ~CheckBox () ;

			// Getters
			virtual bool isChecked () const = 0 ;
			std::function<void (CheckBox*)> getCheckCallback () const ;

			// Setters
			virtual void setChecked (bool val) = 0 ;
			void setCheckCallback (std::function<void (CheckBox*)> value) ;

		public :

			// Statics
			static nkMemory::UniquePtr<CheckBox> create (System* system = nullptr) ;

		protected :
		
			// Attributs
			// Callback
			std::function<void (CheckBox*)> _checkCallback ;
	} ;
}